function [reord] = reordxlstbl(data)
%This little function takes an excel table and reorders it so that each
%column is now a row, e.g.,
%   d1  c1     d1 d2
%   d1  c1     d1 d2
%   d1  c1     d1 d2
% 
% 
%   d2  c2     c1 c2  
%   d2  c2     c1 c2
%   d2  c2     c1 c2
%no labels are used rignt now.  Expects a cell array.
%Synatax:   [sorted] = reordxlstbl(data)
%Input:     data = xlstable data.  In the form of a cell array with one row
%               text (protein names), one row values.
%Output:    sorted = the sorted data table

%parse the data array    
databloc = 0;
spacebloc = 0;
lastspc = 0; %becomes one if the last data point was a space
for k = 1:size(data,1)  %read one column
    if ~isempty(data{k,1});
        if lastspc==0  %not repeating yet
            databloc = databloc+1;
        else  %repeating
            break
        end
    else %spacebloc
        spacebloc = spacebloc+1;
        lastspc = 1;
    end
end

%go through column wise
rowoutidx = 1;
for i = 1:size(data,2)
    colidx = 1;
    rowinidx = 1;
    rowouttmp = rowoutidx;
    dataidx = 0;
    while 1   %go through the rows
        try
        reord(rowouttmp,colidx) = data{rowinidx,i};
        catch
            keyboard
        end
        rowouttmp = rowouttmp+1;
        rowinidx = rowinidx+1;
        dataidx = dataidx+1;
        if dataidx==databloc  %read the end of this bloc
            colidx = colidx+1;
            dataidx = 0;
            rowouttmp = rowoutidx;
            rowinidx = rowinidx+spacebloc; %skip ahead
        end
        if rowinidx>size(data,1)
            break
        end
    end
    reord = vertcat(reord,zeros(spacebloc,size(reord,2)));
    rowoutidx = size(reord,1)+1;
end